#!/bin/sh
set -eu

. $(pwd)/windows_build_vars

(cd openvpn && autoreconf -vi)

mkdir -p build-openvpn-nl
(cd build-openvpn-nl

CFLAGS="${HARDENING_FLAGS} -O2 -I$(pwd)/../tap-windows/src/ -static -D__USE_MINGW_ANSI_STDIO=0" \
MBEDTLS_CFLAGS="-I$(pwd)/../mbedtls/include" \
MBEDTLS_LIBS="-L$(pwd)/../build-mbedtls/library -lmbedtls -lmbedx509 -lmbedcrypto" \
PKCS11_HELPER_CFLAGS="-I$(pwd)/../build-pkcs11-helper/include -I$(pwd)/../pkcs11-helper/include" \
PKCS11_HELPER_LIBS="-L$(pwd)/../build-pkcs11-helper/lib/.libs -lpkcs11-helper" \
../openvpn/configure \
	--host=${CHOST} \
	--build=${CBUILD} \
	--with-crypto-library=mbedtls \
	--enable-pkcs11 \
	--disable-lzo \
	--disable-lz4 \
	--disable-ofb-cfb \
	--disable-plugin-down-root \
	--disable-plugin-auth-pam
)
